rm(list=ls(all=TRUE))
library(lqr); library(pracma); library(nortest); library(moments)


AnalisisDescriptivo<-function(x)
{
	res<-round( mean(x),3 )
	res[2]<-round( sd(x),3 )
	res[3]<-round( median(x),3 )
	res[4]<- round( quantile(x,0.75) - quantile(x,0.25),3 )
	res[5]<-round( min(x),3 )
	res[6]<-round( max(x),3 )
	res[7]<-round( skewness(x),3 )
	res[8]<-round( kurtosis(x),3 )
	names(res)<-c("mean", "s.d.","median","IQR","min",
	"max","skewness","kurtosis") 
 	res 
}

curve.EPM<-function(psi,beta,gamma,lwd=1,xlim=1,ylim=1, add=F)
{
	curve( 
	gamma*pgamma( x^(2*beta)/(2*psi^2),3/2,1 )^(gamma -1)*
		beta*x^(2*beta -1)/(psi^2)*dgamma( x^(2*beta)/(2*psi^2),3/2,1 ),
	ylab="",xlab="w",add=add, lwd=lwd#,
	#xlim=c(0,xlim),ylim=c(0,ylim)
	)
}


EMV.REPM<-function(w,psi.ini=c(1,1,1))
{

logvero<-function(theta,w)
{
	a0=theta[1]; b0=theta[2]; c0=theta[3]; n=length(w)
	beta<-exp(a0); mu<-exp(b0); gamma<-exp(c0); psi<-mu^(beta)
	log.G<-pgamma(w^(2*beta)/(2*psi^2), 3/2,1,log.p=TRUE)
	n*log(gamma) +(gamma -1)*sum(log.G) +n*log(beta) -2*n*log(psi) +
	(2*beta -1)*sum(log(w)) -n*lgamma(3/2) -n*log(sqrt(2)) -n*log(psi) +
	beta*sum(log(w)) -sum( w^(2*beta)/(2*psi^2) )
}
resultado<-optim(psi.ini,logvero,w=w,
method="L-BFGS-B",control=list(fnscale=-1),hessian=T)
beta.estimado<-exp(resultado$par[1])
mu.estimado<-exp(resultado$par[2])
gamma.estimado<-exp(resultado$par[3])
sd<-sqrt( diag(solve(-resultado$hessian)) )
loglike<-resultado$value
AIC<-2*(3) -2*(loglike) 
list(beta.estimado=beta.estimado, mu.estimado=mu.estimado,
gamma.estimado=gamma.estimado,loglike=loglike,sd=sd,Criteria=c(AIC=AIC))
}



EMV.Gamma<-function(x,psi.ini.gamma=c(1.5,1.5))
{

n<-length(x)
logvero.gamma<-function(theta,x)
{
alpha=theta[1]
beta=theta[2]
n=length(x)
sum(dgamma(x,alpha,beta,log=T))
}


resultado<-optim(psi.ini.gamma,logvero.gamma,x=x,lower=c(1e-20,1e-20),
method="L-BFGS-B",control=list(fnscale=-1),hessian=T)
psi<-resultado$par
sd<-sqrt( diag(solve(-resultado$hessian)) )
L<-resultado$value; Log.gamma<- L; psi.gamma.EMV<-c(psi)
AIC<-2*(2) -2*(Log.gamma) 
return(list(psi=psi,sd=sd,L=L,Criteria=c(AIC=AIC)))
}



EMV.PM<-function(x,psi.ini.PM=c(1.5,1.5))
{

n<-length(x)
logvero.pm<-function(theta,x)
{
a=theta[1]
b=theta[2]
n=length(x)
n*log(4) -(n/2)*log(pi) +(3*n/2)*log(a) +n*log(b) -a*sum(x^(2*b))+
(3*b -1)*sum(log(x))
}


resultado<-optim(psi.ini.PM,logvero.pm,x=x,lower=c(1e-20,1e-20),
method="L-BFGS-B",control=list(fnscale=-1),hessian=T)
psi<-resultado$par
sd<-sqrt( diag(solve(-resultado$hessian)) )
L<-resultado$value; Log.PM<- L; psi.PM.EMV<-c(psi)
AIC<-2*(2) -2*(Log.PM) 
return(list(psi=psi,sd=sd,L=L,Criteria=c(AIC=AIC)))
}


EMV.M<-function(x,ini=1.5)
{
	n<-length(x)
	logvero.m<-function(theta,x)
	{
		a0=theta[1]; alpha<-exp(a0)
		n=length(x)
		n*log(4) -(n/2)*log(pi) +(3*n/2)*log(alpha) -alpha*sum(x^(2))+
		(2)*sum(log(x))
	}
	resultado<-optim(ini,logvero.m,x=x,
	method="L-BFGS-B",control=list(fnscale=-1),hessian=T)
	psi<-exp(resultado$par)
	sd<-sqrt( diag(solve(-resultado$hessian)) )
	L<-resultado$value; Log.M<- L; psi.M.EMV<-psi
	AIC<-2*(1) -2*(Log.M) 
	return(list(psi=psi,sd=sd,L=L,Criteria=c(AIC=AIC)))
}


curve.REPM<-function(mu,beta,gamma,lwd=1,xlim=1,ylim=1, add=F)
{
	curve( 
	gamma*pgamma( x^(2*beta)/(2*mu^(2*beta)),3/2,1 )^(gamma -1)*
		beta*x^(2*beta -1)/(mu^(2*beta))*dgamma( x^(2*beta)/(2*mu^(2*beta)),3/2,1 ),
	ylab="",xlab="w",add=add, lwd=lwd#,
	#xlim=c(0,xlim),ylim=c(0,ylim)
	)
}



rREPM<-function(n,mu=1, beta=1, gamma=1)
{
	U<-runif(n); w<-c()
	ifelse(length(mu)==1, mu<- rep(mu, n), mu<-mu)
	ifelse(length(beta)==1, beta<- rep(beta, n), beta<-beta)
	w<-( 2*(mu^(2*beta))*qgamma(U^(1/gamma),3/2,1) )^(1/(2*beta))
	#list(U=U, w=w)
	return(w)	
}

rPM<-function(n,a,b)
{
	aux<-function(a,b)
	{
	y<-rchisq(1,df=3); p<-sqrt(y); v<-p/( sqrt(2*a) ); x<-v^(1/b)
	return(x)
	}

	dat1<-c()
	for(i in 1:n ){ dat1[i]<-aux(a,b) }
	dat1
}

QQ_REPM<-function(x,theta,xlim=c(0,11),ylim=c(0,15), axis=1.6, lab=1.6, lwd=4)
{	
	n<-length(x)
	rrepm<-rREPM(n,theta[1],theta[2],theta[3])
	qqplot(rrepm,x, plot.it = TRUE, xlab = "REPM theoretical quantiles", 
	ylab = "sample quantiles",xlim=xlim,ylim=ylim,cex.axis=axis,cex.lab=lab)
	abline(0,1, lwd=lwd)
}

QQ_PM<-function(x,psi,xlim=c(0,12),ylim=c(0,15),M=FALSE, axis=1.6, lab=1.6, lwd=4)
{
	n<-length(x)
	rpm<-rPM(n,psi[1],psi[2])
	if(M==FALSE){
	qqplot(rpm,x, plot.it = TRUE, xlab = "PM theoretical quantiles", 
	ylab = "sample quantiles",ylim=ylim,xlim=xlim,cex.axis=axis,cex.lab=lab)
	abline(0,1, lwd=lwd)}
	if(M==TRUE){
	qqplot(rpm,x, plot.it = TRUE, xlab = "M theoretical quantiles", 
	ylab = "sample quantiles",ylim=ylim,xlim=xlim,cex.axis=axis,cex.lab=lab)
	abline(0,1, lwd=lwd)}

}


QQ_gamma<-function(x,psi,xlim=c(0,12),ylim=c(0,15),M=FALSE, axis=1.6, lab=1.6, lwd=4)
{
	n<-length(x)
	rg<-rgamma(n,psi[1],psi[2])
	qqplot(rg,x, plot.it = TRUE, xlab = "PM theoretical quantiles", 
	ylab = "sample quantiles",ylim=ylim,xlim=xlim,cex.axis=axis,cex.lab=lab)
	abline(0,1, lwd=lwd)

}


EMV.EPM.covariables.2<-function(w,x1,x2,gamma,psi.ini=c(1,1,1,1))
{

logvero<-function(theta,w)
{
	a0=theta[1]; b0=theta[2]; b1=theta[3]; b2=theta[4]
	psi<-exp(b0 +b1*x1 +b2*x2); alpha<-exp(a0); n=length(w)
	log.G<-pgamma(w^(2*alpha)/(2*psi^2), 3/2,1,log.p=TRUE)
	n*log(gamma) +(gamma -1)*sum(log.G) +n*log(alpha) -2*sum(log(psi)) +
	(2*alpha -1)*sum(log(w)) -n*lgamma(3/2) -n*log(sqrt(2)) -sum( log(psi) ) +
	alpha*sum(log(w)) -sum( w^(2*alpha)/(2*psi^2) )
}
resultado<-optim(psi.ini,logvero,w=w,
method="Nelder-Mea",control=list(fnscale=-1),hessian=T)
a0.estimado<-resultado$par[1]; b0.estimado<-resultado$par[2]; b1.estimado<-resultado$par[3]
b2.estimado<-resultado$par[4]; likelihood<-resultado$value; sd<-sqrt( diag(solve(-resultado$hessian)) )
varianza.estimador<-solve(-resultado$hessian)
list(a0.estimado=a0.estimado, b0.estimado=b0.estimado,b1.estimado=b1.estimado,
b2.estimado=b2.estimado,likelihood=likelihood,sd=sd,varianza.estimador=varianza.estimador)
}



sd.final.2.cov<-function(varianza.original,alpha,b0,b1,b2)
{
derivada<-c(1,-b0/(alpha^2),-b1/(alpha^2),-b2/(alpha^2),0, 1/alpha,0,0,
0,0,1/alpha,0, 0,0,0,1/alpha  )
g.prima<-matrix(derivada,nrow=4,ncol=4,byrow=T)
g.prima.T<-matrix(derivada,nrow=4,ncol=4,byrow=F)
sqrt( diag(g.prima.T%*%varianza.original%*%g.prima) )
}


pREPM<-function(w,beta,mu,gamma)
{
	psi<-mu^beta
	pgamma(w^(2*beta)/(2*psi^2),3/2,1)^gamma
}


REPM.quantile.norm_2.cov<-function(w,x1,x2,beta,b0,b1,b2,gamma)
{
	n<-length(w); r<-c()
	for(i in 1:n)
	{	
		aux1<- b0/beta +b1/beta*x1[i] +b2/beta*x2[i]; mu<-exp(aux1)
		r[i]<-qnorm(pREPM(w[i],beta,mu,gamma))
	}
	r
}



REPM.aplicacion.2.cov<-function(w,x1,x2,rho,psi.ini=c(1,1,1,1),KS=TRUE)
{
	C<-pgamma(1/2,3/2,1); gamma<-log(rho)/log(C); n<-length(w)
	aux.REPM<-EMV.EPM.covariables.2(w,x1,x2,gamma,psi.ini)
	a0<-aux.REPM$a0.estimado; b0<-aux.REPM$b0.estimado; b1<-aux.REPM$b1.estimado; b2<-aux.REPM$b2.estimado; beta<-exp(a0)
	varianza.original<-aux.REPM$varianza.estimador
	sd.final<-sd.final.2.cov(varianza.original,beta,b0,b1,b2)
	AIC.REPM<-2*(4) -2*(aux.REPM$likelihood)
	r<-REPM.quantile.norm_2.cov(w,x1,x2,beta,b0,b1,b2,gamma)
	ifelse(KS==TRUE, p.value<-ks.test(r,pnorm,0,1)$p.value,p.value<-ad.test(r)$p.value)
	list("beta, tau0*, tau1*, tau2*"=c(beta,b0/beta,b1/beta,b2/beta),
	"sd.REPM"=sd.final,"AIC.REPM"=AIC.REPM,"p.value"=p.value)
	
}


Volume.AIC.REPM<-function(w,x1,x2,rho,psi.ini=c(0,0,0,0))
{
	p<-c(); aic<-c(); estimation<-c()
	for(i in 1:length(rho))
	{
		estimation[[i]]<-round(REPM.aplicacion.2.cov(w,x1,x2,rho[i],psi.ini,KS=T)[[1]],3)
		p[i]<-round(REPM.aplicacion.2.cov(w,x1,x2,rho[i],psi.ini,KS=T)[[4]],3)
		aic[i]<-round(REPM.aplicacion.2.cov(w,x1,x2,rho[i],psi.ini,KS=T)[[3]],3)
	}
	return(list(AIC=aic, "p-value"=p, estimation=estimation))
}

EMV.EPM.covariables.3<-function(w,x1,x2,x3,gamma,psi.ini=c(1,1,1,1,1))
{

logvero<-function(theta,w)
{
	a0=theta[1]; b0=theta[2]; b1=theta[3]; b2=theta[4]; b3=theta[5]
	psi<-exp(b0 +b1*x1 +b2*x2 +b3*x3); alpha<-exp(a0); n=length(w)
	log.G<-pgamma(w^(2*alpha)/(2*psi^2), 3/2,1,log.p=TRUE)
	n*log(gamma) +(gamma -1)*sum(log.G) +n*log(alpha) -2*sum(log(psi)) +
	(2*alpha -1)*sum(log(w)) -n*lgamma(3/2) -n*log(sqrt(2)) -sum( log(psi) ) +
	alpha*sum(log(w)) -sum( w^(2*alpha)/(2*psi^2) )
}
resultado<-optim(psi.ini,logvero,w=w,
method="Nelder-Mea",control=list(fnscale=-1),hessian=T)
a0.estimado<-resultado$par[1]; b0.estimado<-resultado$par[2]; b1.estimado<-resultado$par[3]
b2.estimado<-resultado$par[4]; b3.estimado<-resultado$par[5]; likelihood<-resultado$value; sd<-sqrt( diag(solve(-resultado$hessian)) )
varianza.estimador<-solve(-resultado$hessian)
list(a0.estimado=a0.estimado, b0.estimado=b0.estimado,b1.estimado=b1.estimado,
b2.estimado=b2.estimado, b3.estimado=b3.estimado,
likelihood=likelihood,sd=sd,varianza.estimador=varianza.estimador)
}


sd.final.3.cov<-function(varianza.original,alpha,b0,b1,b2,b3)
{
d1<-c(1,-b0/(alpha^2),-b1/(alpha^2),-b2/(alpha^2), -b3/(alpha^2))
d2<-c(0, 1/alpha, 0, 0, 0); d3<-c(0, 0, 1/alpha, 0, 0); d4<-c(0, 0, 0, 1/alpha, 0)
d5<-c(0, 0, 0, 0, 1/alpha)
g.prima<-matrix(c(d1,d2,d3,d4,d5),nrow=5,ncol=5,byrow=T)
g.prima.T<-t(g.prima)
sqrt( diag(g.prima.T%*%varianza.original%*%g.prima) )
}



REPM.quantile.norm_3.cov<-function(w,x1,x2, x3,beta,b0,b1,b2,b3,gamma)
{
	n<-length(w); r<-c()
	for(i in 1:n)
	{	
		aux1<- b0/beta +b1/beta*x1[i] +b2/beta*x2[i] +b3/beta*x2[i]; mu<-exp(aux1)
		r[i]<-qnorm(pREPM(w[i],beta,mu,gamma))
	}
	r
}


REPM.aplicacion.3.cov<-function(w,x1,x2,x3,rho,psi.ini=c(0,0,0,0,0),KS=TRUE)
{
	C<-pgamma(1/2,3/2,1); gamma<-log(rho)/log(C); n<-length(w)
	aux.REPM<-EMV.EPM.covariables.3(w,x1,x2,x3,gamma,psi.ini)
	a0<-aux.REPM$a0.estimado; b0<-aux.REPM$b0.estimado; b1<-aux.REPM$b1.estimado; 
	b2<-aux.REPM$b2.estimado; b3<-aux.REPM$b3.estimado; beta<-exp(a0)
	varianza.original<-aux.REPM$varianza.estimador
	sd.final<-sd.final.3.cov(varianza.original,beta,b0,b1,b2,b3)
	AIC.REPM<-2*(5) -2*(aux.REPM$likelihood)
	r<-REPM.quantile.norm_3.cov(w,x1,x2, x3,beta,b0,b1,b2,b3,gamma)
	ifelse(KS==TRUE, p.value<-ks.test(r,pnorm,0,1)$p.value,p.value<-ad.test(r)$p.value)
	list("beta, tau0, tau1, tau2, tau3"=c(beta,b0/beta,b1/beta,b2/beta, b3/beta),
	"sd.REPM"=sd.final,"AIC.REPM"=AIC.REPM,"p.value"=p.value)
	
}



SKD.quantile.norm<-function(y,X,beta,sigma,nu,rho,dist=c("t","laplace"))
{
	n<-length(y); r<-c()
	for(i in 1:n)
	{	
		mu<- as.vector(X[i,]%*%beta)
		if(dist=="t"){r[i]<-qnorm(pSKD(y[i],mu=mu,sigma=sigma,p=rho, dist="t", nu=nu))}
		if(dist=="laplace"){r[i]<-qnorm(pSKD(y[i],mu=mu,sigma=sigma,p=rho, dist="laplace"))}
	}
	r
}

p.AIC.SKD<-function(w,X,rho,dist=c("t","laplace"))
{
	p<-c(); aic<-c()
	for(i in 1:length(rho))
	{
		aa<-lqr(w, x=X, p = rho[i], dist = dist)
		beta<-aa$beta; sigma<-aa$sigma
		nu<-ifelse(dist=="t", nu<-min(99.9999,round(aa$nu,3)), nu<-1)
		aic[i]<-aa$AIC
		r<-ifelse(
		dist=="t",
			r<-SKD.quantile.norm(w,X, beta,sigma,nu,rho[i],dist="t"),
			r<-SKD.quantile.norm(w,X, beta,sigma,nu,rho[i],dist="laplace")
		)
		p[i]<-ks.test(r,pnorm,0,1)$p.value
	}
	return(list(AIC=aic, "p-value"=p))
}

dSCG<-function(x,par,log=FALSE)
{
	mu=par[1]
	sigma=par[2]
	lambda=par[3]
	phi=par[4]
	z=(x-mu)/sigma
	logf<-log(lambda)-log(sigma)-log(pi)+log(cosh(z))-log1p((lambda*sinh(z))^2)-lgamma(phi)+(phi-1)*log(-log1p(-0.5-(1/pi)*atan(lambda*sinh(z))))
	if(log==FALSE)
	{logf=exp(logf)}
	logf
}
solve.phi<-function(phi,q)
{
	pgamma(-log(1/2),shape=phi)-q
}
logvero.SCG.cov<-function(par,x,Z,phi)
{
	r=nrow(Z)
	beta=par[1:r]
	sigma=exp(par[r+1])
	lambda=exp(par[r+2])
	mu<-t(Z)%*%beta
	z=(x-mu)/sigma
	logf<-log(lambda)-log(sigma)-log(pi)+log(cosh(z))-log1p((lambda*sinh(z))^2)-lgamma(phi)+(phi-1)*log(-log1p(-0.5-(1/pi)*atan(lambda*sinh(z))))
	-sum(logf)
}
logvero2.SCG.cov<-function(par,x,Z,phi)
{
	r=nrow(Z)
	beta=par[1:r]
	sigma=par[r+1]
	lambda=par[r+2]
	mu<-t(Z)%*%beta
	z=(x-mu)/sigma
	logf<-log(lambda)-log(sigma)-log(pi)+log(cosh(z))-log1p((lambda*sinh(z))^2)-lgamma(phi)+(phi-1)*log(-log1p(-0.5-(1/pi)*atan(lambda*sinh(z))))
	-sum(logf)
}



